/**
 * 
 */
package gov.va.med.mhv.liferay.autologin.api.security;

import java.io.IOException;

import javax.servlet.http.HttpSession;
import javax.ws.rs.client.ClientRequestContext;
import javax.ws.rs.client.ClientRequestFilter;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.servlet.PortalSessionThreadLocal;

import gov.va.med.mhv.liferay.autologin.PostRegistrationAutoLogin;

/**
 * @author DNS
 *
 */
public class HttpSessionScreenNameClientRequestFilter implements ClientRequestFilter {

	private static final Log logger = LogFactoryUtil.getLog(HttpSessionScreenNameClientRequestFilter.class);

	private static final String API_APP_KEY = "appToken";
	private static final String API_MHV_USERNAME_KEY = "mhvUsername";
	private static final String SESSION_USERNAME_KEY = "LIFERAY_SHARED_userid";
	private static final String APP_TOKEN = "MyHealth3Vet123";

	/*
	 * (non-Javadoc)
	 * 
	 * @see javax.ws.rs.client.ClientRequestFilter#filter(javax.ws.rs.client.
	 * ClientRequestContext)
	 */
	@Override
	public void filter(ClientRequestContext requestContext) throws IOException {
		try {
			HttpSession session = PortalSessionThreadLocal.getHttpSession();
			String mhvUsername = (String) session.getAttribute(PostRegistrationAutoLogin.ATTR_SCREEN_NAME);

			if (mhvUsername == null) {
				logger.info("PostRegistrationAutoLogin: Unable to get mhvCorrelationId or mhvUsername from session.");
				throw new IOException("Unable to get mhvCorrelationId or mhvUsername from session");
			}

			if (mhvUsername != null) {
				logger.info("PostRegistrationAutoLogin: Adding '" + API_APP_KEY + "' and '" + API_MHV_USERNAME_KEY + "' to API Client Request for "
						+ API_MHV_USERNAME_KEY + " " + mhvUsername);
			}

			requestContext.getHeaders().add(API_APP_KEY, APP_TOKEN);
			requestContext.getHeaders().add(API_MHV_USERNAME_KEY, mhvUsername);
		} catch (Exception e) {
			logger.info("PostRegistrationAutoLogin: Unable to access client http session.");
			e.printStackTrace();
			throw new IOException("Unable to access client http session", e);
		}
	}
}
